using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Data;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Margaret Jablonski</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>8/13/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary></summary>
	public class FrmTransfusionComplicationsReport : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		private BOL.TransfusionComplicationsReport _report;
        private DataSet _dsReport = new DataSet();

		#endregion

		#region Form Controls
		private System.Windows.Forms.GroupBox grpImage;
        private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.PrintDialog printDialog1;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvTransfusionComplications;
		private System.ComponentModel.IContainer components = null;
		#endregion

		#region Constructors/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="report"></param>
		public FrmTransfusionComplicationsReport(BOL.TransfusionComplicationsReport report)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			//
			this._report = report;
			//
			SetComponentProperties();
			//
			using (new WaitCursor())
			{
				this.CreateReport();
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmTransfusionComplicationsReport));
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnPrint = new System.Windows.Forms.Button();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            this.rvTransfusionComplications = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.TabIndex = 3;
            this.vbecsLogo1.Title = "Transfusion Complications Report";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.TabIndex = 5;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 412);
            this.grpImage.TabIndex = 4;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(45, 45);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(564, 448);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 2;
            this.btnCancel.Text = "&Close";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(484, 448);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 1;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // rvTransfusionComplications
            // 
            this.rvTransfusionComplications.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvTransfusionComplications.Location = new System.Drawing.Point(60, 37);
            this.rvTransfusionComplications.Name = "rvTransfusionComplications";
            this.rvTransfusionComplications.Size = new System.Drawing.Size(579, 405);
            this.rvTransfusionComplications.TabIndex = 6;
            // 
            // FrmTransfusionComplicationsReport
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(642, 473);
            this.Controls.Add(this.rvTransfusionComplications);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnPrint);
            this.Controls.Add(this.grpImage);
            this.hlphelpChm.SetHelpKeyword(this, "Transfusion_Complications_Report.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(600, 450);
            this.Name = "FrmTransfusionComplicationsReport";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Transfusion Complications Report";
            this.Load += new System.EventHandler(this.FrmTransfusionComplicationsReport_Load);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.rvTransfusionComplications, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		#region Methods
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC090.FrmTransfusionComplicationsReport());
            BOL.VbecsReport.SetUpReportButtons(this.rvTransfusionComplications);
        }

		private void CreateReport()
		{
            _dsReport = this._report.GenerateReport();
            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(this._report.ReportCriteria);

#if DEBUG
            //_dsReport.Tables[0].WriteXml("e:\\temp\\TransfusionComplicationsDataSet.xml", XmlWriteMode.WriteSchema);
            //_dsReport.Tables[1].WriteXml("e:\\temp\\TransfusionComplicationThresholdsDataSet.xml", XmlWriteMode.WriteSchema);
#endif
           ReportDataSource reportSourceMain = new ReportDataSource();
            if (_dsReport.Tables.Count > 0)
            {
                reportSourceMain.Name = "TransfusionComplicationsDataSet";
                reportSourceMain.Value = _dsReport.Tables[0];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionComplications.TransfusionComplicationsReport.rdlc");
            Stream streamThresholds = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionComplications.TransfusionComplicationThresholds.rdlc");

            this.rvTransfusionComplications.LocalReport.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);

            this.rvTransfusionComplications.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvTransfusionComplications.LocalReport.DataSources.Add(reportSourceFooter);
            this.rvTransfusionComplications.LocalReport.DataSources.Add(reportSourceMain);
            this.rvTransfusionComplications.LocalReport.LoadReportDefinition(stream);
            this.rvTransfusionComplications.LocalReport.LoadSubreportDefinition("TransfusionComplicationThresholds", streamThresholds);

            this.rvTransfusionComplications.RefreshReport();
        }

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "TransfusionComplicationThresholds" || e.DataSourceNames[0].ToString() == "TransfusionComplicationThresholdsDataSet")
            {
                ReportDataSource reportTests = new ReportDataSource();
                if (_dsReport.Tables.Count > 1)
                {
                    reportTests.Name = "TransfusionComplicationThresholdsDataSet";
                    reportTests.Value = _dsReport.Tables[1];
                }
                e.DataSources.Add(reportTests);
            }
        }
		#endregion

		#region Events / Event Handlers

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
            //CR 3449
            try
            {
                this.rvTransfusionComplications.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

		#endregion

        private void FrmTransfusionComplicationsReport_Load(object sender, EventArgs e)
        {

            this.rvTransfusionComplications.RefreshReport();
        }


	}
}

